/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;

public abstract class AbstractTestGraphMaker
extends GraphTestBase {
    private GraphMaker gf;

    public AbstractTestGraphMaker(String string) {
        super(string);
    }

    public abstract GraphMaker getGraphFactory();

    public void setUp() {
        this.gf = this.getGraphFactory();
    }

    public void tearDown() {
        this.gf.close();
    }

    public void testGetGraph() {
        Graph graph = this.gf.getGraph();
        AbstractTestGraphMaker.assertFalse((String)"should deliver a Graph", (graph == null ? 1 : 0) != 0);
        AbstractTestGraphMaker.assertSame((Object)graph, (Object)this.gf.getGraph());
        graph.close();
    }

    public void testCreateGraph() {
        AbstractTestGraphMaker.assertDiffer("each created graph must differ", this.gf.createGraph(), this.gf.createGraph());
    }

    public void testAnyName() {
        this.gf.createGraph("plain").close();
        this.gf.createGraph("with.dot").close();
        this.gf.createGraph("http://electric-hedgehog.net/topic#marker").close();
    }

    public void testCannotCreateTwice() {
        String string = this.jName("bonsai");
        this.gf.createGraph(string, true);
        try {
            this.gf.createGraph(string, true);
            AbstractTestGraphMaker.fail((String)("should not be able to create " + string + " twice"));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    private String jName(String string) {
        return "jena_test_" + string;
    }

    public void testCanCreateTwice() {
        String string = this.jName("bridge");
        Graph graph = this.gf.createGraph(string, true);
        Graph graph2 = this.gf.createGraph(string, false);
        AbstractTestGraphMaker.assertTrue((String)"graphs should be the same", (boolean)this.sameGraph(graph, graph2));
        Graph graph3 = this.gf.createGraph(string);
        AbstractTestGraphMaker.assertTrue((String)"graphs should be the same", (boolean)this.sameGraph(graph, graph3));
    }

    public void testCannotOpenUncreated() {
        String string = this.jName("noSuchGraph");
        try {
            this.gf.openGraph(string, true);
            AbstractTestGraphMaker.fail((String)(string + " should not exist"));
        }
        catch (DoesNotExistException doesNotExistException) {
            // empty catch block
        }
    }

    public void testCanOpenUncreated() {
        String string = this.jName("willBeCreated");
        Graph graph = this.gf.openGraph(string);
        graph.close();
        this.gf.openGraph(string, true);
    }

    private void testExists(String string) {
        AbstractTestGraphMaker.assertTrue((String)(string + " should exist"), (boolean)this.gf.hasGraph(string));
    }

    private void testDoesNotExist(String string) {
        AbstractTestGraphMaker.assertFalse((String)(string + " should exist"), (boolean)this.gf.hasGraph(string));
    }

    public void testCanFindCreatedGraph() {
        String string = this.jName("alpha");
        String string2 = this.jName("beta");
        Graph graph = this.gf.createGraph(string, true);
        Graph graph2 = this.gf.createGraph(string2, true);
        Graph graph3 = this.gf.openGraph(string, true);
        Graph graph4 = this.gf.openGraph(string2, true);
        AbstractTestGraphMaker.assertTrue((String)"should find alpha", (boolean)this.sameGraph(graph, graph3));
        AbstractTestGraphMaker.assertTrue((String)"should find beta", (boolean)this.sameGraph(graph2, graph4));
    }

    private boolean sameGraph(Graph graph, Graph graph2) {
        Node node = AbstractTestGraphMaker.node("S");
        Node node2 = AbstractTestGraphMaker.node("P");
        Node node3 = AbstractTestGraphMaker.node("O");
        graph.add(new Triple(node, node2, node3));
        graph2.add(new Triple(node3, node2, node));
        return graph2.contains(node, node2, node3) && graph.contains(node3, node2, node);
    }

    public void testCanRemoveGraph() {
        String string = this.jName("bingo");
        String string2 = this.jName("brillo");
        this.gf.createGraph(string, true);
        this.gf.createGraph(string2, true);
        this.testExists(string);
        this.testExists(string2);
        this.gf.removeGraph(string);
        this.testExists(string2);
        this.testDoesNotExist(string);
    }

    public void testHasnt() {
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.createGraph("john", true);
        AbstractTestGraphMaker.assertTrue((String)"john now exists", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.createGraph("paul", true);
        AbstractTestGraphMaker.assertTrue((String)"john still exists", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertTrue((String)"paul now exists", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.removeGraph("john");
        AbstractTestGraphMaker.assertFalse((String)"john has been removed", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertTrue((String)"paul still exists", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
    }

    public void testCarefulClose() {
        Graph graph = this.gf.createGraph("x");
        Graph graph2 = this.gf.openGraph("x");
        graph.add(AbstractTestGraphMaker.triple("a BB c"));
        graph.close();
        graph2.add(AbstractTestGraphMaker.triple("p RR q"));
        graph2.close();
    }
}

