/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GraphMatcher {
    private static Random random = new Random(0L);
    private static final boolean TRACE = false;
    private Graph m;
    private GraphMatcher other;
    private int myHashLevel = 0;
    private static final int MAX_HASH_DEPTH = 3;
    private Map table;
    private int state;
    private static final int REHASHING = 1;
    private static final int HASH_OK = 2;
    private static final int HASH_BAD = 4;
    private Set unboundAnonResources = new HashSet();
    private Set boundAnonResources = new HashSet();
    private boolean refinableHash;
    private static final int NOVARS = 0;
    private static final int SX = 1;
    private static final int PX = 4;
    private static final int OX = 16;
    private static final int SD = 2;
    private static final int PD = 8;
    private static final int OD = 32;
    private static final int SXPY = 5;
    private static final int SXOY = 17;
    private static final int PXOY = 20;
    private static final int SXPYOZ = 21;
    private static final int SXPX = 10;
    private static final int SXOX = 34;
    private static final int PXOX = 40;
    private static final int SXPXOY = 26;
    private static final int SXPYOX = 38;
    private static final int SXPYOY = 41;
    private static final int SXPXOX = 42;
    private static final int S = 3;
    private static final int P = 12;
    private static final int O = 48;
    private Map anonLookup = new HashMap();
    private static int col = 0;
    private static boolean lastDir = false;

    public static boolean equals(Graph graph, Graph graph2) {
        if (graph == graph2) {
            return true;
        }
        return GraphMatcher.match(graph, graph2) != null;
    }

    public static int hashCode(Graph graph) {
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        int n = 0;
        GraphMatcher graphMatcher = new GraphMatcher(graph);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            GraphMatcher graphMatcher2 = graphMatcher;
            graphMatcher2.getClass();
            n += graphMatcher2.new AnonStatement(triple).myHashCode(null);
        }
        return n;
    }

    public static Node[][] match(Graph graph, Graph graph2) {
        return new GraphMatcher(graph).match(new GraphMatcher(graph2));
    }

    private GraphMatcher(Graph graph) {
        this.m = graph;
    }

    private Node[][] match(GraphMatcher graphMatcher) {
        this.other = graphMatcher;
        graphMatcher.other = this;
        this.in(4);
        if (this.m.size() != this.other.m.size()) {
            return null;
        }
        int n = this.prepare(this.other.m);
        if (n == -1 || n != this.other.prepare(this.m)) {
            return null;
        }
        if (this.bind()) {
            if (!this.unboundAnonResources.isEmpty()) {
                GraphMatcher.impossible();
            }
            Node[][] nodeArray = new Node[this.boundAnonResources.size()][];
            int n2 = 0;
            Iterator iterator = this.boundAnonResources.iterator();
            while (iterator.hasNext()) {
                AnonResource anonResource = (AnonResource)iterator.next();
                nodeArray[n2++] = new Node[]{anonResource.r, anonResource.bound.r};
            }
            return nodeArray;
        }
        return null;
    }

    private boolean bind() {
        Set set = this.obligBindings();
        if (set == null) {
            return false;
        }
        this.check(2);
        Bucket bucket = this.smallestBucket();
        if (bucket == null) {
            return true;
        }
        Bucket bucket2 = this.other.matchBucket(bucket);
        if (bucket2 != null) {
            AnonResource anonResource = bucket.aMember();
            Iterator iterator = bucket2.members();
            while (iterator.hasNext()) {
                this.check(6);
                AnonResource anonResource2 = (AnonResource)iterator.next();
                GraphMatcher.trace(true, "Guess: ");
                if (!bucket.bind(anonResource, bucket2, anonResource2)) continue;
                if (this.bind()) {
                    return true;
                }
                anonResource.unbind();
            }
        }
        this.unbindAll(set);
        return false;
    }

    private Set obligBindings() {
        boolean bl;
        int n = 0;
        HashSet<AnonResource> hashSet = new HashSet<AnonResource>();
        this.check(6);
        do {
            if (this.rehash(n) != this.other.rehash(n)) {
                this.unbindAll(hashSet);
                return null;
            }
            this.refinableHash = false;
            bl = false;
            Iterator iterator = this.scanBuckets();
            while (iterator.hasNext()) {
                bl = true;
                Bucket bucket = (Bucket)iterator.next();
                Bucket bucket2 = this.other.matchBucket(bucket);
                if (bucket2 == null) {
                    this.unbindAll(hashSet);
                    return null;
                }
                AnonResource anonResource = bucket.aMember();
                if (!bucket.bind(bucket2)) {
                    this.unbindAll(hashSet);
                    return null;
                }
                hashSet.add(anonResource);
            }
            if (bl) {
                n = 0;
                continue;
            }
            ++n;
        } while (n < 3 && (this.refinableHash || bl));
        return hashSet;
    }

    private Iterator scanBuckets() {
        this.check(2);
        return new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Bucket bucket = (Bucket)object;
                if (bucket.size() == 1) {
                    return true;
                }
                if (!GraphMatcher.this.refinableHash) {
                    Iterator iterator = bucket.members();
                    while (iterator.hasNext()) {
                        if (((AnonResource)iterator.next()).friends.isEmpty()) continue;
                        GraphMatcher.this.refinableHash = true;
                        break;
                    }
                }
                return false;
            }
        }, this.table.values().iterator());
    }

    private void unbindAll(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((AnonResource)iterator.next()).unbind();
        }
        this.in(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepare(Graph graph) {
        ExtendedIterator extendedIterator = this.m.find(null, null, null);
        this.myHashLevel = 0;
        int n = 0;
        try {
            while (extendedIterator.hasNext()) {
                int n2;
                Triple triple = (Triple)extendedIterator.next();
                AnonStatement anonStatement = new AnonStatement(triple);
                if (anonStatement.pattern == 0) {
                    ExtendedIterator extendedIterator2 = graph.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
                    n2 = extendedIterator2.hasNext();
                    extendedIterator2.close();
                    if (n2 != 0) continue;
                    int n4 = -1;
                    return n4;
                }
                n += anonStatement.myHashCode(anonStatement.vars[0]);
                for (int i = 0; i < anonStatement.vars.length; ++i) {
                    anonStatement.vars[i].occursIn.add(anonStatement);
                    for (n2 = i + 1; n2 < anonStatement.vars.length; ++n2) {
                        anonStatement.vars[i].friends.add(anonStatement.vars[n2]);
                        anonStatement.vars[n2].friends.add(anonStatement.vars[i]);
                    }
                }
            }
            int n5 = n == -1 ? 1 : n;
            return n5;
        }
        finally {
            extendedIterator.close();
        }
    }

    private Bucket smallestBucket() {
        this.check(2);
        Iterator iterator = this.table.values().iterator();
        Bucket bucket = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            Bucket bucket2 = (Bucket)iterator.next();
            int n2 = bucket2.size();
            if (n2 >= n) continue;
            bucket = bucket2;
            n = n2;
        }
        return bucket;
    }

    private Bucket matchBucket(Bucket bucket) {
        this.check(2);
        Integer n = new Integer(bucket.aMember().myHash);
        Bucket bucket2 = (Bucket)this.table.get(n);
        if (bucket2 != null && bucket.size() != bucket2.size()) {
            return null;
        }
        return bucket2;
    }

    private int rehash(int n) {
        return this.rehash0(n);
    }

    private int rehash0(int n) {
        Object object;
        Object object2;
        this.in(1);
        this.table = new HashMap();
        this.myHashLevel = n;
        Iterator iterator = this.unboundAnonResources.iterator();
        while (iterator.hasNext()) {
            AnonResource anonResource = (AnonResource)iterator.next();
            object2 = new Integer(anonResource.myHashCode());
            object = (Bucket)this.table.get(object2);
            if (object == null) {
                object = new Bucket();
                this.table.put(object2, object);
            }
            ((Bucket)object).add(anonResource);
        }
        int n2 = 0;
        object2 = this.table.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n4 = (Integer)object.getKey();
            Bucket bucket = (Bucket)object.getValue();
            int n5 = bucket.size();
            n2 += n5 * 65537 ^ n4;
        }
        this.in(2);
        return n2;
    }

    private static boolean legalPattern(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    private static int varPosInPattern(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n != 0) break;
                return 1;
            }
            case 16: {
                if (n != 0) break;
                return 16;
            }
            case 4: {
                if (n != 0) break;
                return 4;
            }
            case 5: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 17: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 20: {
                switch (n) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 21: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 16;
                    }
                }
                break;
            }
            case 10: {
                if (n != 0) break;
                return 10;
            }
            case 34: {
                if (n != 0) break;
                return 34;
            }
            case 40: {
                if (n != 0) break;
                return 40;
            }
            case 26: {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 38: {
                switch (n) {
                    case 0: {
                        return 34;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 41: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 40;
                    }
                }
                break;
            }
            case 42: {
                if (n != 0) break;
                return 42;
            }
        }
        System.out.println("Bad: " + n + " " + n2);
        GraphMatcher.impossible();
        return 0;
    }

    static void count(Map map, SomeResource someResource, int n) {
        if (someResource instanceof AnonResource) {
            int[] nArray = (int[])map.get(someResource);
            if (nArray == null) {
                nArray = new int[]{-1, -1, -1};
                map.put(someResource, nArray);
            }
            for (int i = 0; i < 3; ++i) {
                if (nArray[i] != -1) continue;
                nArray[i] = n;
                return;
            }
        }
    }

    private SomeResource convert(Node node) {
        if (node.isBlank()) {
            SomeResource someResource = (SomeResource)this.anonLookup.get(node);
            if (someResource == null) {
                someResource = new AnonResource(node);
                this.anonLookup.put(node, someResource);
            }
            return someResource;
        }
        return new FixedResource(node);
    }

    private void check(int n) {
        if ((this.state & n) == 0) {
            GraphMatcher.impossible();
        }
    }

    private void in(int n) {
        this.state = n;
        this.other.state = n;
    }

    private static void impossible() {
        throw new JenaException("Cannot happen!");
    }

    private static void trace(boolean bl, String string) {
    }

    private static void traceNL() {
    }

    private class AnonResource
    implements SomeResource {
        AnonResource bound;
        Node r;
        Set occursIn = new HashSet();
        int[] hash = new int[3];
        int boundHash;
        Set friends = new HashSet();
        int myHash;

        public String toString() {
            String string = this.r.toString();
            if (this.bound != null) {
                string = string + "[" + this.bound.r.toString() + "]";
            }
            return string;
        }

        AnonResource(Node node) {
            GraphMatcher.this.unboundAnonResources.add(this);
            this.r = node;
        }

        public int myHashCodeFromStatement() {
            if (this.bound != null) {
                return this.boundHash;
            }
            if (GraphMatcher.this.myHashLevel == 0) {
                return -889275714;
            }
            GraphMatcher.this.check(3);
            return this.hash[GraphMatcher.this.myHashLevel - 1];
        }

        int myHashCode() {
            GraphMatcher.this.check(1);
            if (this.bound != null) {
                GraphMatcher.impossible();
            }
            this.myHash = 0;
            Iterator iterator = this.occursIn.iterator();
            while (iterator.hasNext()) {
                AnonStatement anonStatement = (AnonStatement)iterator.next();
                this.myHash += anonStatement.myHashCode(this);
            }
            this.hash[((GraphMatcher)GraphMatcher.this).myHashLevel] = this.myHash;
            return this.myHash;
        }

        void bind(AnonResource anonResource) {
            this.bound = anonResource;
            if (!GraphMatcher.this.unboundAnonResources.remove(this)) {
                GraphMatcher.impossible();
            }
            GraphMatcher.this.boundAnonResources.add(this);
            if (anonResource.bound == null) {
                GraphMatcher.trace(true, this.r.getBlankNodeId() + "=" + anonResource.r.getBlankNodeId() + ", ");
                anonResource.bind(this);
                this.bound.boundHash = this.boundHash = random.nextInt();
            }
            if (this.bound.bound != this) {
                GraphMatcher.impossible();
            }
        }

        void unbind() {
            AnonResource anonResource = this.bound;
            this.bound = null;
            if (!GraphMatcher.this.boundAnonResources.remove(this)) {
                GraphMatcher.impossible();
            }
            GraphMatcher.this.unboundAnonResources.add(this);
            if (anonResource.bound != null) {
                GraphMatcher.trace(false, this.r.getBlankNodeId() + "!=" + anonResource.r.getBlankNodeId() + ", ");
                if (anonResource.bound != this) {
                    GraphMatcher.impossible();
                }
                anonResource.unbind();
            }
            GraphMatcher.this.in(4);
        }

        boolean checkBinding(AnonResource anonResource) {
            Set set;
            if (this.occursIn.size() != anonResource.occursIn.size()) {
                return false;
            }
            Set set2 = this.wrapStatements();
            return set2.removeAll(set = anonResource.wrapStatements()) && set2.isEmpty();
        }

        private Set wrapStatements() {
            if (GraphMatcher.this.state == 4) {
                GraphMatcher.this.myHashLevel = 0;
            }
            HashSet<StatementWrapper> hashSet = new HashSet<StatementWrapper>();
            Iterator iterator = this.occursIn.iterator();
            while (iterator.hasNext()) {
                hashSet.add(this.wrapStatement((AnonStatement)iterator.next()));
            }
            return hashSet;
        }

        public boolean mightBeEqual(SomeResource someResource) {
            if (someResource != null && someResource instanceof AnonResource) {
                AnonResource anonResource = (AnonResource)someResource;
                return anonResource == this || this.bound == anonResource || this.bound == null && anonResource.bound == null;
            }
            return false;
        }

        StatementWrapper wrapStatement(AnonStatement anonStatement) {
            return new StatementWrapper(anonStatement);
        }

        private class StatementWrapper {
            int hash;
            AnonStatement statement;

            public boolean equals(Object object) {
                if (object == null || !(object instanceof StatementWrapper)) {
                    return false;
                }
                StatementWrapper statementWrapper = (StatementWrapper)object;
                return this.hash == statementWrapper.hash && this.statement.contextualEquals(AnonResource.this, statementWrapper.statement, statementWrapper.asAnonR());
            }

            public int hashCode() {
                return this.hash;
            }

            StatementWrapper(AnonStatement anonStatement) {
                this.hash = anonStatement.myHashCode(AnonResource.this);
                this.statement = anonStatement;
            }

            AnonResource asAnonR() {
                return AnonResource.this;
            }
        }
    }

    private class Bucket {
        Set anonRes = new HashSet();
        int[] hash = new int[3];

        private Bucket() {
        }

        boolean bind(Bucket bucket) {
            return this.bind(this.aMember(), bucket, bucket.aMember());
        }

        boolean bind(AnonResource anonResource, Bucket bucket, AnonResource anonResource2) {
            if (anonResource.checkBinding(anonResource2)) {
                anonResource.bind(anonResource2);
                return true;
            }
            return false;
        }

        void add(AnonResource anonResource) {
            this.anonRes.add(anonResource);
        }

        AnonResource aMember() {
            return (AnonResource)this.anonRes.iterator().next();
        }

        Iterator members() {
            return this.anonRes.iterator();
        }

        int size() {
            return this.anonRes.size();
        }
    }

    private class AnonStatement {
        int varCount;
        AnonResource[] vars;
        SomeResource subj;
        SomeResource pred;
        SomeResource obj;
        int pattern;

        AnonStatement(Triple triple) {
            HashMap hashMap = new HashMap();
            this.pattern = 0;
            this.subj = GraphMatcher.this.convert(triple.getSubject());
            this.pred = GraphMatcher.this.convert(triple.getPredicate());
            this.obj = GraphMatcher.this.convert(triple.getObject());
            GraphMatcher.count(hashMap, this.subj, 0);
            GraphMatcher.count(hashMap, this.pred, 2);
            GraphMatcher.count(hashMap, this.obj, 4);
            this.varCount = hashMap.size();
            this.vars = new AnonResource[this.varCount];
            this.add(this.subj);
            this.add(this.pred);
            this.add(this.obj);
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                int[] nArray = (int[])iterator.next();
                int n = 2;
                while (nArray[n] == -1) {
                    --n;
                }
                int n2 = n == 0 ? 1 : 2;
                for (int i = 0; i <= n; ++i) {
                    this.pattern |= n2 << nArray[i];
                }
            }
            if (!GraphMatcher.legalPattern(this.pattern)) {
                System.out.println("s: " + this.subj + " p: " + this.pred + " o: " + this.obj + " pattern: " + this.pattern);
                GraphMatcher.impossible();
            }
        }

        private void add(SomeResource someResource) {
            if (someResource instanceof AnonResource) {
                for (int i = 0; i < this.vars.length; ++i) {
                    if (this.vars[i] != null && this.vars[i] != someResource) continue;
                    this.vars[i] = (AnonResource)someResource;
                    return;
                }
                GraphMatcher.impossible();
            }
        }

        int varPos(AnonResource anonResource) {
            if (anonResource == null) {
                return 0;
            }
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] != anonResource) continue;
                return GraphMatcher.varPosInPattern(i, this.pattern);
            }
            GraphMatcher.impossible();
            return 0;
        }

        int myHashCode(AnonResource anonResource) {
            int n;
            int n2 = n = this.varPos(anonResource);
            if ((n & 3) == 0) {
                n2 ^= this.subj.myHashCodeFromStatement() * 257;
            }
            if ((n & 0xC) == 0) {
                n2 ^= this.pred.myHashCodeFromStatement() * 63;
            }
            if ((n & 0x30) == 0) {
                n2 ^= this.obj.myHashCodeFromStatement() * 65;
            }
            return n2;
        }

        boolean contextualEquals(AnonResource anonResource, AnonStatement anonStatement, AnonResource anonResource2) {
            int n = this.varPos(anonResource);
            if (n != anonStatement.varPos(anonResource2)) {
                return false;
            }
            return !((n & 3) == 0 && !this.subj.mightBeEqual(anonStatement.subj) || (n & 0xC) == 0 && !this.pred.mightBeEqual(anonStatement.pred) || (n & 0x30) == 0 && !this.obj.mightBeEqual(anonStatement.obj));
        }
    }

    private static class FixedResource
    implements SomeResource {
        int hash;
        Node node;

        public String toString() {
            return "f" + this.hash;
        }

        public int myHashCodeFromStatement() {
            return this.hash;
        }

        FixedResource(Node node) {
            this.hash = node.hashCode();
            this.node = node;
        }

        public boolean mightBeEqual(SomeResource someResource) {
            if (someResource != null && someResource instanceof FixedResource) {
                FixedResource fixedResource = (FixedResource)someResource;
                return this.hash == fixedResource.hash && this.node.equals(fixedResource.node);
            }
            return false;
        }
    }

    private static interface SomeResource {
        public int myHashCodeFromStatement();

        public boolean mightBeEqual(SomeResource var1);
    }
}

