/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestReifierCompareToMem
extends TestCase {
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$db$test$TestReifierCompareToMem == null ? (class$com$hp$hpl$jena$db$test$TestReifierCompareToMem = TestReifierCompareToMem.class$("com.hp.hpl.jena.db.test.TestReifierCompareToMem")) : class$com$hp$hpl$jena$db$test$TestReifierCompareToMem));
    Model modelrdb = null;
    Model modelmem = null;
    IDBConnection conn = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestReifierCompareToMem;

    public TestReifierCompareToMem(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestReifierCompareToMem == null ? (class$com$hp$hpl$jena$db$test$TestReifierCompareToMem = TestReifierCompareToMem.class$("com.hp.hpl.jena.db.test.TestReifierCompareToMem")) : class$com$hp$hpl$jena$db$test$TestReifierCompareToMem);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.modelrdb = ModelRDB.createModel(this.conn);
        this.modelmem = new ModelMem();
    }

    protected void tearDown() throws Exception {
        this.modelrdb.close();
        this.modelrdb = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addRemove(Statement statement) {
        this.modelrdb.add(statement);
        this.modelmem.add(statement);
        this.compareModels();
        this.modelrdb.remove(statement);
        this.modelmem.remove(statement);
        this.compareModels();
    }

    private void compareModels() {
        Statement statement;
        StmtIterator stmtIterator = this.modelmem.listStatements();
        while (stmtIterator.hasNext()) {
            statement = (Statement)stmtIterator.next();
            if (!this.modelrdb.contains(statement)) {
                logger.error((Object)("Statment:" + statement + " is in mem but not rdf"));
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdb, "RDF");
            }
            TestReifierCompareToMem.assertTrue((boolean)this.modelrdb.contains(statement));
        }
        stmtIterator = this.modelrdb.listStatements();
        while (stmtIterator.hasNext()) {
            statement = (Statement)stmtIterator.next();
            if (!this.modelmem.contains(statement)) {
                logger.error((Object)("Statment:" + statement + " is in rdf but not memory"));
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdb, "RDF");
            }
            TestReifierCompareToMem.assertTrue((boolean)this.modelmem.contains(statement));
        }
        TestReifierCompareToMem.assertTrue((this.modelmem.size() == this.modelrdb.size() ? 1 : 0) != 0);
    }

    private void logModel(Model model, String string) {
        logger.debug((Object)"Model");
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = (Statement)stmtIterator.next();
            RDFNode rDFNode = statement.getObject();
            if (rDFNode instanceof Literal) {
                logger.debug((Object)(string + ": " + statement.getSubject() + statement.getPredicate() + ((Literal)rDFNode).getValue() + " " + ((Literal)rDFNode).getDatatype() + " " + ((Literal)rDFNode).getLanguage()));
                continue;
            }
            logger.debug((Object)(string + ": " + stmtIterator.next()));
        }
    }

    public void testAddPredicate() {
        Resource resource = this.modelrdb.createResource("SSS");
        Resource resource2 = this.modelrdb.createResource("OOO");
        Statement statement = this.modelrdb.createStatement(resource, RDF.object, resource2);
        this.modelrdb.add(statement);
        this.modelmem.add(statement);
        this.compareModels();
        this.modelrdb.remove(statement);
        this.modelmem.remove(statement);
        this.compareModels();
    }

    public void testAddRemoveFullReification() {
        Resource resource = this.modelrdb.createResource("SSS");
        Resource resource2 = this.modelrdb.createResource("PPP");
        Resource resource3 = this.modelrdb.createResource("OOO");
        Statement statement = this.modelrdb.createStatement(resource, RDF.type, RDF.Statement);
        Statement statement2 = this.modelrdb.createStatement(resource, RDF.subject, resource);
        Statement statement3 = this.modelrdb.createStatement(resource, RDF.predicate, resource2);
        Statement statement4 = this.modelrdb.createStatement(resource, RDF.object, resource3);
        this.modelrdb.add(statement);
        this.modelmem.add(statement);
        this.compareModels();
        this.modelrdb.add(statement2);
        this.modelmem.add(statement2);
        this.compareModels();
        this.modelrdb.add(statement3);
        this.modelmem.add(statement3);
        this.compareModels();
        this.modelrdb.add(statement4);
        this.modelmem.add(statement4);
        this.compareModels();
        this.modelrdb.remove(statement4);
        this.modelmem.remove(statement4);
        this.compareModels();
        this.modelrdb.remove(statement3);
        this.modelmem.remove(statement3);
        this.compareModels();
        this.modelrdb.remove(statement2);
        this.modelmem.remove(statement2);
        this.compareModels();
        this.modelrdb.remove(statement);
        this.modelmem.remove(statement);
        this.compareModels();
    }

    public void testAddRemoveLiteralObject() {
        Resource resource = this.modelrdb.createResource("test#subject");
        Literal literal = this.modelrdb.createLiteral("testLiteral");
        this.addRemove(this.modelrdb.createStatement(resource, RDF.object, literal));
    }

    public void testAddRemoveHugeLiteralObject() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelrdb.createResource("test#subject");
        Literal literal = this.modelrdb.createLiteral(stringBuffer.toString());
        this.addRemove(this.modelrdb.createStatement(resource, RDF.object, literal));
    }

    public void testAddRemoveDatatypeObject() {
        Resource resource = this.modelrdb.createResource("test#subject");
        Literal literal = this.modelrdb.createTypedLiteral("stringType");
        this.addRemove(this.modelrdb.createStatement(resource, RDF.object, literal));
    }

    public void testAddRemoveHugeDatatypeObject() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelrdb.createResource("test#subject");
        Literal literal = this.modelrdb.createTypedLiteral(stringBuffer.toString());
        this.addRemove(this.modelrdb.createStatement(resource, RDF.object, literal));
    }

    public void testAddRemoveHugeLiteral2Object() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.modelmem.createResource("test#subject");
        Literal literal = this.modelmem.createLiteral(stringBuffer.toString());
        Literal literal2 = this.modelmem.createLiteral(stringBuffer.toString() + ".");
        Statement statement = this.modelmem.createStatement(resource, RDF.object, literal);
        Statement statement2 = this.modelmem.createStatement(resource, RDF.object, literal2);
        this.modelrdb.add(statement);
        this.modelmem.add(statement);
        this.compareModels();
        this.modelrdb.add(statement2);
        this.modelmem.add(statement2);
        this.compareModels();
        this.modelrdb.remove(statement2);
        this.modelmem.remove(statement2);
        this.compareModels();
        this.modelrdb.remove(statement);
        this.modelmem.remove(statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

