/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.Free;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarIndex;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;

public final class DBQueryStageCompiler {
    public static DBQuery compile(DBQueryStageCompiler dBQueryStageCompiler, DBQueryHandler dBQueryHandler, SpecializedGraph specializedGraph, List list, List list2, Graph graph) {
        DBQuery dBQuery = new DBQuery(specializedGraph, list, dBQueryHandler.queryOnlyStmt, dBQueryHandler.queryOnlyReif, dBQueryHandler.queryFullReif);
        for (int i = 0; i < list2.size(); ++i) {
            DBQueryStageCompiler.compilePattern(dBQueryStageCompiler, dBQuery, (DBPattern)list2.get(i));
        }
        DBQueryStageCompiler.compileConstraints(dBQueryStageCompiler, dBQuery, graph);
        DBQueryStageCompiler.compileQuery(dBQueryStageCompiler, dBQuery);
        return dBQuery;
    }

    private static void compilePattern(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery, DBPattern dBPattern) {
        Element element = dBPattern.S;
        Element element2 = dBPattern.O;
        Element element3 = dBPattern.P;
        String string = null;
        int n = dBQuery.aliasCnt;
        if (dBQuery.isReifier) {
            char c;
            boolean bl = true;
            if (!(element3 instanceof Fixed)) {
                throw new JenaException("Reifier predicate not bound");
            }
            Node node = ((Fixed)element3).asNodeMatch(null);
            if (node.equals(RDF.Nodes.subject)) {
                c = 'S';
            } else if (node.equals(RDF.Nodes.predicate)) {
                c = 'P';
            } else if (node.equals(RDF.Nodes.object)) {
                c = 'O';
            } else if (node.equals(RDF.Nodes.type)) {
                c = 'T';
            } else {
                throw new JenaException("Unexpected reifier predicate");
            }
            if (!element.equals(Element.ANY)) {
                if (dBQuery.qryFullReif && element instanceof Free && dBQuery.getBinding(((Free)element).getListing()).isBoundToCol()) {
                    n = dBQuery.getBinding((int)((Free)element).getListing()).alias;
                    bl = false;
                } else {
                    string = dBQuery.ga.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'N', element));
                }
            }
            string = string + dBQuery.ga.gen(DBQueryStageCompiler.getQual(dBQuery, n, c, element2));
            string = string + dBQuery.ga.gen(dBQuery.driver.genSQLQualGraphId(n, dBQuery.graphId));
            if (bl) {
                dBQuery.newAlias();
            }
        } else {
            string = dBQuery.ga.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'S', element));
            string = string + dBQuery.ga.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'P', element3));
            string = string + dBQuery.ga.gen(DBQueryStageCompiler.getQual(dBQuery, n, 'O', element2));
            string = string + dBQuery.ga.gen(dBQuery.driver.genSQLQualGraphId(n, dBQuery.graphId));
            dBQuery.newAlias();
        }
        dBQuery.stmt = dBQuery.stmt + string;
    }

    private static String getQual(DBQuery dBQuery, int n, char c, Element element) {
        String string = "";
        if (element instanceof Fixed) {
            string = dBQuery.driver.genSQLQualConst(n, c, ((Fixed)element).asNodeMatch(null));
        } else if (element instanceof Free) {
            Free free = (Free)element;
            VarIndex varIndex = dBQuery.getBinding(free.getListing());
            if (free.isArg() && !varIndex.isBoundToCol) {
                ++dBQuery.argCnt;
                dBQuery.argType = dBQuery.argType + c;
                dBQuery.argIndex.add(new Integer(free.getMapping()));
                string = dBQuery.driver.genSQLQualParam(n, c);
                varIndex.bindToCol(n, c);
            } else if (varIndex.isBoundToCol()) {
                string = dBQuery.driver.genSQLJoin(varIndex.alias, varIndex.column, n, c);
            } else {
                varIndex.bindToCol(n, c);
                string = "";
            }
        } else if (element != Element.ANY) {
            throw new JenaException("Invalid Element in qualifier");
        }
        return string;
    }

    private static void compileConstraints(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery, Graph graph) {
    }

    private static void compConstraints(DBQuery dBQuery, Node_Variable node_Variable, Graph graph) {
        Triple triple;
        Triple[] tripleArray = new Triple[graph.size()];
        int n = 0;
        ExtendedIterator extendedIterator = graph.find(node_Variable, Node.ANY, Node.ANY);
        while (extendedIterator.hasNext()) {
            triple = (Triple)extendedIterator.next();
            if (!DBQueryStageCompiler.genConstraints(dBQuery, (Node_Variable)triple.getSubject(), triple.getPredicate(), triple.getObject())) continue;
            tripleArray[n++] = triple;
        }
        --n;
        while (n > 0) {
            graph.delete(tripleArray[n]);
            --n;
        }
        extendedIterator = graph.find(Node.ANY, Node.ANY, node_Variable);
        while (extendedIterator.hasNext()) {
            triple = (Triple)extendedIterator.next();
            if (!DBQueryStageCompiler.genConstraints(dBQuery, (Node_Variable)triple.getObject(), triple.getPredicate(), triple.getSubject())) continue;
            tripleArray[n++] = triple;
        }
        --n;
        while (n > 0) {
            graph.delete(tripleArray[n]);
            --n;
        }
    }

    private static boolean genConstraints(DBQuery dBQuery, Node_Variable node_Variable, Node node, Node node2) {
        boolean bl = false;
        return bl;
    }

    private static void compileQuery(DBQueryStageCompiler dBQueryStageCompiler, DBQuery dBQuery) {
        int n = dBQuery.binding.length - dBQuery.argCnt;
        dBQuery.resList = new int[n];
        dBQuery.stmt = dBQuery.driver.genSQLSelectStmt(dBQuery.driver.genSQLResList(dBQuery.resList, dBQuery.binding), dBQuery.driver.genSQLFromList(dBQuery.aliasCnt, dBQuery.table), dBQuery.stmt);
    }
}

