/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.DB;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DBPropDatabase
extends DBProp {
    public static final Node_URI dbEngineType = (Node_URI)DB.engineType.getNode();
    public static final Node_URI dbLayoutVersion = (Node_URI)DB.layoutVersion.getNode();
    public static final Node_URI dbDriverVersion = (Node_URI)DB.driverVersion.getNode();
    public static final Node_URI dbFormatDate = (Node_URI)DB.formatDate.getNode();
    public static final Node_URI dbGraph = (Node_URI)DB.graph.getNode();
    public static final Node_URI dbLongObjectLength = (Node_URI)DB.longObjectLength.getNode();
    public static final Node_URI dbIndexKeyLength = (Node_URI)DB.indexKeyLength.getNode();
    public static final Node_URI dbIsTransactionDb = (Node_URI)DB.isTransactionDb.getNode();
    public static final Node_URI dbDoCompressURI = (Node_URI)DB.doCompressURI.getNode();
    public static final Node_URI dbCompressURILength = (Node_URI)DB.compressURILength.getNode();
    public static final Node_URI dbTableNamePrefix = (Node_URI)DB.tableNamePrefix.getNode();
    public static final String dbSystemGraphName = "SystemGraph";
    protected static SimpleDateFormat dateFormat = null;
    static final Map1 graphToName = new Map1(){

        public Object map1(Object object) {
            return ((DBPropGraph)object).getName();
        }
    };

    public DBPropDatabase(SpecializedGraph specializedGraph, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        super(specializedGraph);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        String string10 = dateFormat.format(new Date());
        if (string != null) {
            this.putPropString(dbEngineType, string);
        }
        if (string2 != null) {
            this.putPropString(dbDriverVersion, string2);
        }
        this.putPropString(dbLayoutVersion, string3);
        this.putPropString(dbFormatDate, string10);
        this.putPropString(dbLongObjectLength, string4);
        this.putPropString(dbIndexKeyLength, string5);
        this.putPropString(dbIsTransactionDb, string6);
        this.putPropString(dbDoCompressURI, string7);
        this.putPropString(dbCompressURILength, string8);
        this.putPropString(dbTableNamePrefix, string9);
    }

    public DBPropDatabase(SpecializedGraph specializedGraph, Node node) {
        super(specializedGraph, node);
    }

    public DBPropDatabase(SpecializedGraph specializedGraph) {
        super(specializedGraph, DBPropDatabase.findDBPropNode(specializedGraph));
    }

    public String getName() {
        return this.self.getURI();
    }

    public String getEngineType() {
        return this.getPropString(dbEngineType);
    }

    public String getDriverVersion() {
        return this.getPropString(dbDriverVersion);
    }

    public String getFormatDate() {
        return this.getPropString(dbFormatDate);
    }

    public String getLayoutVersion() {
        return this.getPropString(dbLayoutVersion);
    }

    public String getLongObjectLength() {
        return this.getPropString(dbLongObjectLength);
    }

    public String getIndexKeyLength() {
        return this.getPropString(dbIndexKeyLength);
    }

    public String getIsTransactionDb() {
        return this.getPropString(dbIsTransactionDb);
    }

    public String getDoCompressURI() {
        return this.getPropString(dbDoCompressURI);
    }

    public String getCompressURILength() {
        return this.getPropString(dbCompressURILength);
    }

    public String getTableNamePrefix() {
        return this.getPropString(dbTableNamePrefix);
    }

    public void addGraph(DBPropGraph dBPropGraph) {
        this.putPropNode(dbGraph, dBPropGraph.getNode());
    }

    public void removeGraph(DBPropGraph dBPropGraph) {
        SpecializedGraph.CompletionFlag completionFlag = DBPropDatabase.newComplete();
        ExtendedIterator extendedIterator = this.graph.find(this.self, dbGraph, dBPropGraph.getNode(), completionFlag);
        if (extendedIterator.hasNext()) {
            this.graph.delete((Triple)extendedIterator.next(), completionFlag);
            dBPropGraph.remove();
        }
    }

    public ExtendedIterator getAllGraphs() {
        return this.graph.find(this.self, dbGraph, null, DBPropDatabase.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator getAllGraphNames() {
        return this.getAllGraphs().mapWith(graphToName);
    }

    static Node findDBPropNode(SpecializedGraph specializedGraph) {
        ExtendedIterator extendedIterator = specializedGraph.find(null, dbEngineType, null, DBPropDatabase.newComplete());
        if (extendedIterator.hasNext()) {
            return ((Triple)extendedIterator.next()).getSubject();
        }
        return null;
    }

    private class MapToLSet
    implements Map1 {
        private MapToLSet() {
        }

        public Object map1(Object object) {
            Triple triple = (Triple)object;
            return new DBPropGraph(DBPropDatabase.this.graph, triple.getObject());
        }
    }
}

