/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jfor.jfor.converter.AfterBuilder;
import org.jfor.jfor.converter.BasicLinkBuilder;
import org.jfor.jfor.converter.BeforeBuilder;
import org.jfor.jfor.converter.BuilderContext;
import org.jfor.jfor.converter.ConverterLogChannel;
import org.jfor.jfor.converter.ConverterOption;
import org.jfor.jfor.converter.ExternalGraphicBuilder;
import org.jfor.jfor.converter.IBuilder;
import org.jfor.jfor.converter.IConverterOption;
import org.jfor.jfor.converter.IgnoreChildrenNullBuilder;
import org.jfor.jfor.converter.ListBuilder;
import org.jfor.jfor.converter.ListItemBuilder;
import org.jfor.jfor.converter.ListItemLabelBuilder;
import org.jfor.jfor.converter.NullBuilder;
import org.jfor.jfor.converter.PageBuilder;
import org.jfor.jfor.converter.PageNumberBuilder;
import org.jfor.jfor.converter.PageNumberCitationBuilder;
import org.jfor.jfor.converter.ParagraphBuilder;
import org.jfor.jfor.converter.SectionBuilder;
import org.jfor.jfor.converter.StyleSheetBuilder;
import org.jfor.jfor.converter.TableBuilder;
import org.jfor.jfor.converter.TableCellBuilder;
import org.jfor.jfor.converter.TableColumnBuilder;
import org.jfor.jfor.converter.TableRowBuilder;
import org.jfor.jfor.converter.TemplateBuilder;
import org.jfor.jfor.converter.TextBuilder;
import org.jfor.jfor.main.JForVersionInfo;
import org.jfor.jfor.tools.DomToSaxAdapter;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Converter
extends DefaultHandler {
    private boolean m_debugSaxEvents = false;
    private StringBuffer m_characterBuffer = new StringBuffer();
    private static final Set IGNORED_TAGNAMES = new HashSet();
    private final IConverterOption m_options;
    private final ConverterLogChannel m_log;
    private final List m_builders = new LinkedList();
    private final BuilderContext m_context;
    private IBuilder m_builder;
    private long m_start;

    public Converter(InputSource inputSource, Writer writer, IConverterOption iConverterOption) throws Exception {
        this.m_options = iConverterOption;
        this.m_log = this.m_options.getLog();
        this.m_context = new BuilderContext(writer, this.m_log, iConverterOption);
        this.setupConverter();
        XMLReader xMLReader = this.m_options.getXmlReader();
        xMLReader.setContentHandler(this);
        this.m_log.logInfo("Parsing xsl:fo document...");
        xMLReader.parse(inputSource);
    }

    public Converter(Writer writer, IConverterOption iConverterOption) throws Exception {
        this.m_options = iConverterOption;
        this.m_log = this.m_options.getLog();
        this.m_context = new BuilderContext(writer, this.m_log, iConverterOption);
        this.setupConverter();
        this.m_log.logInfo("Parsing xsl:fo document...");
    }

    public Converter(Document document, Writer writer, IConverterOption iConverterOption) throws Exception {
        this.m_options = iConverterOption;
        this.m_log = this.m_options.getLog();
        this.m_context = new BuilderContext(writer, this.m_log, iConverterOption);
        this.setupConverter();
        DomToSaxAdapter domToSaxAdapter = new DomToSaxAdapter(document);
        this.m_log.logInfo("Analyzing xsl:fo document...");
        domToSaxAdapter.simulateParsing(this);
    }

    private void writeRtf() throws IOException {
        this.m_log.logInfo("Writing out RTF...");
        this.m_context.getRtfFile().flush();
        this.m_log.logInfo("Done converting xsl:fo to RTF.");
    }

    private void setupConverter() {
        this.m_log.logInfo(JForVersionInfo.getShortVersionInfo() + " - setting up conversion...");
        this.m_builders.add(new NullBuilder(this.m_context, IGNORED_TAGNAMES));
        this.m_builders.add(new PageBuilder(this.m_context));
        this.m_builders.add(new PageNumberCitationBuilder(this.m_context));
        this.m_builders.add(new SectionBuilder(this.m_context));
        this.m_builders.add(new BeforeBuilder(this.m_context));
        this.m_builders.add(new ParagraphBuilder(this.m_context));
        this.m_builders.add(new TextBuilder(this.m_context));
        this.m_builders.add(new PageNumberBuilder(this.m_context));
        this.m_builders.add(new TableBuilder(this.m_context));
        this.m_builders.add(new TableRowBuilder(this.m_context));
        this.m_builders.add(new TableCellBuilder(this.m_context));
        this.m_builders.add(new TableColumnBuilder(this.m_context));
        this.m_builders.add(new ListBuilder(this.m_context));
        this.m_builders.add(new ListItemBuilder(this.m_context));
        this.m_builders.add(new ListItemLabelBuilder(this.m_context));
        this.m_builders.add(new ExternalGraphicBuilder(this.m_context));
        this.m_builders.add(new BasicLinkBuilder(this.m_context));
        this.m_builders.add(new StyleSheetBuilder(this.m_context));
        this.m_builders.add(new TemplateBuilder(this.m_context));
        this.m_builders.add(new AfterBuilder(this.m_context));
        this.m_builders.add(new NullBuilder(this.m_context, null));
        this.m_start = System.currentTimeMillis();
    }

    private void logDuration() {
        long l = System.currentTimeMillis() - this.m_start;
        this.m_context.log.logDebug("conversion took " + l + " milliseconds.");
    }

    private void debugSaxEvents(String string, String string2, Attributes attributes, boolean bl) {
        if (string2 == null) {
            string2 = "null";
        }
        if (attributes != null) {
            System.out.println(string + (bl ? " Start:" : " End:") + string2);
            if (bl) {
                int n = 0;
                while (n < attributes.getLength()) {
                    System.out.println("     " + attributes.getLocalName(n) + "-" + attributes.getValue(n));
                    ++n;
                }
            }
        } else {
            System.out.println(string + (bl ? " Start:" : " End:") + string2 + " Attributes=null");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.maybeProcessCharacters();
        if (this.m_debugSaxEvents) {
            this.debugSaxEvents(string2, string3, attributes, true);
        }
        IBuilder iBuilder = null;
        if (this.m_builder != null && this.m_builder.ignoreChildren()) {
            iBuilder = new IgnoreChildrenNullBuilder(this.m_context);
        } else if (this.m_builder != null && this.m_builder.useForChildren(string3, attributes)) {
            iBuilder = this.m_builder;
        } else {
            Iterator iterator = this.m_builders.iterator();
            while (iterator.hasNext()) {
                IBuilder iBuilder2 = (IBuilder)iterator.next();
                iBuilder = iBuilder2.getBuilder(this.m_context, string3, attributes);
                if (iBuilder != null) break;
            }
        }
        if (iBuilder == null) {
            throw new SAXException("no builder found for element '" + string3 + "'");
        }
        this.m_builder = iBuilder;
        this.m_context.pushBuilder(this.m_builder);
        try {
            this.m_builder.preStart(string3, attributes);
            this.m_builder.start(string3, attributes);
        }
        catch (IOException iOException) {
            throw new SAXException("IOException in IBuilder: " + iOException.toString());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_debugSaxEvents) {
            this.debugSaxEvents(string2, string3, null, false);
        }
        this.maybeProcessCharacters();
        try {
            this.m_builder.end();
            this.m_builder.postEnd();
        }
        catch (IOException iOException) {
            throw new SAXException("IOException in IBuilder: " + iOException.toString());
        }
        this.m_builder = this.m_context.popBuilderAndGetPreviousOne();
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_characterBuffer.append(cArray, n, n2);
    }

    public void processCharacters(String string) throws SAXException {
        try {
            if (this.m_builder != null) {
                this.m_builder.characters(string);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("IOException in IBuilder: " + iOException.toString());
        }
    }

    private void maybeProcessCharacters() throws SAXException {
        if (this.m_characterBuffer.length() > 0) {
            this.processCharacters(this.m_characterBuffer.toString());
            this.m_characterBuffer = new StringBuffer();
        }
    }

    public void startDocument() throws SAXException {
        this.maybeProcessCharacters();
    }

    public void endDocument() throws SAXException {
        this.maybeProcessCharacters();
        try {
            this.writeRtf();
            this.logDuration();
        }
        catch (IOException iOException) {
            throw new SAXException("IOException writing RTF file: " + iOException.getMessage());
        }
    }

    public static ConverterOption createConverterOption() {
        return new ConverterOption();
    }

    public static ConverterOption createConverterOption(OutputStream outputStream) {
        return new ConverterOption(outputStream);
    }

    public static ConverterOption createConverterOption(OutputStream outputStream, OutputStream outputStream2, OutputStream outputStream3, OutputStream outputStream4) {
        return new ConverterOption(outputStream, outputStream2, outputStream3, outputStream4);
    }

    public static ConverterOption createConverterOption(Writer writer, Writer writer2, Writer writer3, Writer writer4) {
        return new ConverterOption(writer, writer2, writer3, writer4);
    }
}

